unit DataModule;

interface

uses
  Windows, SysUtils, Classes, DB, ADODB, Forms, Dialogs;

const cnMaxLen = 255;

type
  TDM = class(TDataModule)
    ADOConnection1: TADOConnection;
    ADODataSet: TADODataSet;
    ADODataSetBrowse: TADODataSet;
    ADODataSetBrowseidosoby: TAutoIncField;
    ADODataSetBrowsenazwisko: TWideStringField;
    ADODataSetBrowseimie: TWideStringField;
    ADODataSetBrowsedataur: TDateTimeField;
    ADODataSetBrowsemcowosc: TWideStringField;
    ADODataSetBrowseulicainr: TWideStringField;
    ADODataSetBrowsekodp: TWideStringField;
    ADODataSetBrowsemiasto: TWideStringField;
    ADODataSetBrowsepesel: TWideStringField;
    ds: TDataSource;
    adocINSERT: TADOCommand;
    adocEDIT: TADOCommand;
    adocDELETE: TADOCommand;
    ADODataSetidosoby: TAutoIncField;
    ADODataSetnazwisko: TWideStringField;
    ADODataSetimie: TWideStringField;
    ADODataSetdataur: TDateTimeField;
    ADODataSetmcowosc: TWideStringField;
    ADODataSetulicainr: TWideStringField;
    ADODataSetkodp: TWideStringField;
    ADODataSetmiasto: TWideStringField;
    ADODataSetpesel: TWideStringField;
    procedure DataModuleDestroy(Sender: TObject);
    procedure DataModuleCreate(Sender: TObject);

  private
    function GetConnectionString() : String;
    function DajNazweKomputera() : String;

  public

  end;

var
  DM: TDM;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
function TDM.DajNazweKomputera() : String;
var
	sCompName     : String;
   dwCompNameLen : DWord;

begin
	dwCompNameLen := cnMaxLen - 1;
   SetLength(sCompName, cnMaxLen);
   GetComputerName(Pchar(sCompName), dwCompNameLen);
   SetLength(sCompName, dwCompNameLen);

   Result := sCompName;

   if dwCompNameLen = cnMaxLen-1 then
   begin
      Result := '';
   end
   else begin
      Result := UpperCase(Result[1]) + LowerCase(Copy(Result,2,Length(Result)-1));
   end;
end;

procedure TDM.DataModuleCreate(Sender: TObject);
var
	isOK    : Boolean;
   cs      : String;
   bBrakCS : Boolean;
   nazwak  : String;

begin
	bBrakCS := false;

   (*
   prba poczenia z lokalnym serwerem SQL Server 2005 Express

   dla lokalnego poczenia z MS SQL Server 2005 Express - z baz danych Biblioteka - CS jest zbudowane nastepujco:                                                        tutaj nazwa komputera + \SQLEXPRESS

   //                                                                                                             tutaj nazwa komputera + \SQLEXPRESS
	Provider=SQLNCLI.1;Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=Biblioteka;Data Source=NAZWA_KOMPUTERA\SQLEXPRESS

	*)
   nazwak := DajNazweKomputera();
   cs := 'Provider=SQLNCLI.1;Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=Biblioteka;Data Source=' + nazwak + '\SQLEXPRESS';


   isOK := false;

	try
      ADOConnection1.Close();

      if cs <> '' then
      begin
         ADOConnection1.ConnectionString := cs;
    	   ADOConnection1.Connected        := true;
         isOK := true;
      end
      else begin
         bBrakCS := true;
      end;
	except
		ShowMessage('Bd poczenia z serwerem bazy danych');
      Application.Terminate();
   end;

   // jeeli poczenie zlokalnym serwerem si udao
   if isOK then
   begin
		ADODataSet.Open();
      ADODataSetBrowse.Open();
   	exit;
   end;


	// jeeli poaczenie z lokalnym serwerem si nie udao to pobieram CS z pliku CS.TXT
   isOK := false;
	try
      ADOConnection1.Close();
      cs := GetConnectionString();

      if cs <> '' then
      begin
         ADOConnection1.ConnectionString := cs;
    	   ADOConnection1.Connected        := true;
      end
      else begin
         bBrakCS := true;
      end;
	except
		ShowMessage('Bd poczenia z serwerem bazy danych - ZDEFINUJ WASNY ConnectionString');
      Application.Terminate();
   end;

   if isOK then
   begin
		ADODataSet.Open();
      ADODataSetBrowse.Open();
   end;
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   ADODataSet.Close();
   ADODataSetBrowse.Close();
   ADOConnection1.Close();
   // ADOConnection1.Connected := false;
end;

function TDM.GetConnectionString() : String;
var
   cs : String;
   fn : String;
   fh : TextFile;

begin
	cs := '';
   fn := ExtractFilePath(Application.ExeName) + 'cs.txt';
   if FileExists(fn) then
   begin
   	try
			Reset(fh, fn);
      	Readln(fh, cs);
      	cs := Trim(cs);
      finally
	      CloseFile(fh);
      end;
   end;

   Result := cs;
end;

end.

